DELIMITER $$
DROP PROCEDURE IF EXISTS V20220512120838__Update_CourseWiseWeeklySummary $$
CREATE PROCEDURE V20220512120838__Update_CourseWiseWeeklySummary()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT id FROM dtprovider WHERE `dataProviderName`='MSG_COURSEWISE_WEEKLY_ATTENDANCE_RCPNT')) THEN 
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='MSG_COURSEWISE_WEEKLY_ATTENDANCE_RCPNT');
UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT
    T5.studentId AS ID,
    T7.printName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobilecountrycode AS MOBILE_CODE,
    T3.nameToBePrinted AS COURSE_NAME,
    T3.courseCode AS COURSE_CODE,
    T11.componentType AS COMPONENT_DESC,
    T9.firstName AS FACULTY_FIRSTNAME,
    T9.lastName AS FACULTY_LASTNAME,
    T10.salutationName AS SALUTATION,
    T15.printName AS BATCH_NAME,
    T16.programNameToBePrint AS PROGRAM_NAME,
    T17.printName AS PERIOD_NAME,
    T18.displayName AS ACADEMY_NAME,
    ml.code AS LANGUAGE_KEY,
    COUNT(IF(scad.attendanceStatus = 'PRESENT',
        scad.attendanceStatus,
        NULL)) + COUNT(IF(scad.attendanceStatus <> 'PRESENT',
        scad.attendanceStatus,
        NULL)) AS `TOTAL_SESSIONS`,
    COUNT(IF(scad.attendanceStatus = 'PRESENT',
        scad.attendanceStatus,
        NULL)) AS `TOTAL_PRESENT`,
    COUNT(IF(scad.attendanceStatus = 'ABSENT',
        scad.attendanceStatus,
        NULL)) AS `TOTAL_ABSENT`,
    COUNT(IF(scad.attendanceStatus = 'LEAVE',
        scad.attendanceStatus,
        NULL)) AS `TOTAL_LEAVE`,
    ROUND((COUNT(IF(scad.attendanceStatus = 'PRESENT',
                scad.attendanceStatus,
                NULL)) / (COUNT(IF(scad.attendanceStatus = 'PRESENT',
                scad.attendanceStatus,
                NULL)) + COUNT(IF(scad.attendanceStatus <> 'PRESENT',
                scad.attendanceStatus,
                NULL)))) * 100) AS `PRESENT_PERCENTAGE`
FROM
    student_course_attendance sca
        LEFT JOIN
    student_course_attendance_details scad ON sca.id = scad.attendanceId
        LEFT JOIN
    courses T3 ON T3.id = sca.courseId
        LEFT JOIN
    course_components T4 ON T4.id = sca.courseComponentId
        LEFT JOIN
    admission T5 ON T5.id = scad.admissionId
        LEFT JOIN
    students T6 ON T6.userId = T5.studentId
        LEFT JOIN
    persons T7 ON T7.id = T6.personId
        LEFT JOIN
    staffs T8 ON T8.userId = sca.facultyId
        LEFT JOIN
    persons T9 ON T9.id = T8.personId
        LEFT JOIN
    salutations T10 ON T10.id = T9.salutationId
        LEFT JOIN
    component_type T11 ON T11.id = T4.componentTypeId
        LEFT JOIN
    program_batch_students T14 ON T14.admissionId = T5.id
        inner JOIN
    student_course_enrollment T20 ON T20.admissionId = T14.admissionId
        AND T20.programBatchPeriodConfigId = T14.progBatchPeriodConfigId
        AND T20.courseVarientId = sca.variantId
        AND T20.sectionId = sca.sectionId
        LEFT JOIN
    batches T15 ON T15.id = T14.programBatchId
        LEFT JOIN
    programs T16 ON T16.id = T15.programId
        LEFT JOIN
    prog_batch_period_config T17 ON T17.id = T14.progBatchPeriodConfigId
    and T20.programBatchPeriodConfigId=T17.id
        LEFT JOIN
    academy_location T18 ON T18.id = T16.academyLocationId
        LEFT JOIN
    multi_language ml ON T7.correspondence_language = ml.id
WHERE
    T5.studentId IN (namedParams) and T14.isCurrentPeriod=true and T14.isCurrentSection=true 
GROUP BY sca.courseid , sca.courseComponentId , sca.sectionId , sca.variantId , T5.studentId
ORDER BY sca.courseId DESC" , 
`jsonString`='{
 "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },        
        {
            "id": 2,
            "value": "printName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "courseName",
            "resultKey": "COURSE_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "componentDesc",
            "resultKey": "COMPONENT_DESC",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "TOTAL_PRESENT",
            "resultKey": "TOTAL_PRESENT",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "TOTAL_ABSENT",
            "resultKey": "TOTAL_ABSENT",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "PRESENT_PERCENTAGE",
            "resultKey": "PRESENT_PERCENTAGE",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "salutationName",
            "resultKey": "SALUTATION",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "firstName",
            "resultKey": "FACULTY_FIRSTNAME",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "lastName",
            "resultKey": "FACULTY_LASTNAME",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "courseCode",
            "resultKey": "COURSE_CODE",
            "displayCode": "",
            "displayOrder": 12
        }
    ]}'

 WHERE `dataProviderId`=@dtproviderId;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20220512120838__Update_CourseWiseWeeklySummary () $$
DROP PROCEDURE IF EXISTS V20220512120838__Update_CourseWiseWeeklySummary $$
DELIMITER ;